//More Menu
 (function($){
	$.fn.styleddropdown = function(){
		return this.each(function(){
			var obj = $(this);
			obj.find('.field').click(function() { 
			$(".list").fadeOut(200);
			obj.find('.list').fadeIn(400);
			
			$(document).keyup(function(event) { 
				if(event.keyCode == 27) {
				obj.find('.list').fadeOut(400);
				}
			});
			
			obj.find('.list').hover(function(){ },
				function(){
					$(this).fadeOut(400);
				});
			});
			
			obj.find('.list li').click(function() {
			obj.find('.field')
				.val($(this).html())
				.css({
					'background':'#fff',
					'color':'#333'
				});
			obj.find('.list').fadeOut(400);
			});
		});
	};
})(jQuery);

$(function(){
	$('.size').styleddropdown();
});
  
function closeDialog(id) {
	$('#'+id).dialog('close');
}

//for adhoc report name edit
function validateAdhocReportEditForm(reportId, oldName) {
	var reportName = $("#report_name_" + reportId).val();
	//var reportDescription = $("#report_description_" + reportId).val();
	var error_message = '';
	if(reportName == '' || reportName == null) {
		error_message = 'Report Name is required.<br>';
	}
	if(error_message == '') {
		clean_report_name = encodeURIComponent(reportName);
		$.ajax({
			url : '/reports/edit_report_attributes/?report_id='+reportId +'&report_name='+clean_report_name+'&'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(), 
			success: function(data,statusText,xhr) {
				var data_arr = $.parseJSON(data);
				var modifiedTime = '';
				$.each(data_arr, function(key, value) {
					modifiedTime = value;
				});
				//alert(time_display);
				var report_name_link_innerhtml = $('#report_name_link_' + reportId).html();
				$('#edit_report_dialog' + reportId).fadeOut('slow');
				setTimeout(function(){
					$('#edit_report_dialog' + reportId).dialog('close');
					},360);
				$('#report_name_link_' + reportId).html(report_name_link_innerhtml.replace(oldName, reportName));
				$('#modified_time' + reportId).html(modifiedTime);
				$('#report_name_link_' + reportId).effect("highlight", {}, 2500);
				//update edit report dialog window title
				$('#edit_report_dialog' + reportId).dialog('option', 'title', 'Edit Name for Ad-hoc Report: ' + reportName);
				//update user management window title
				$('#dialog' + reportId).dialog('option', 'title', reportName);
				$('#save_report_name_btn' + reportId).attr("onclick","validateAdhocReportEditForm("+reportId+",'"+reportName+"')");
				
				$('#report_table').dataTable().fnDestroy();
				initializeAdhocReportDatatable();
			}
		});
	}
	else {
		$('#error_message_div' + reportId).html(error_message);
		$('#error_message_div' + reportId).fadeIn('slow');
	}
}

function validateAdhocReportSaveForm() {
	var error_message = '';
	var selectedReportAccess = $('input[name=report_access]:checked', '#adhoc_form').val();
	
	
	//$('#save_button').attr("class","adhoc_button_disabled");
	
	if($("#report_name").val().length > 50) {
		error_message += 'Report Name cannot be longer than 50 charaters.<br>';
	}
	if($('#report_name').val() == '' || $('#report_name').val() == null) {
		error_message += 'Report Name is required.<br>';
	}
	if($("#report_decription").val().length > 200) {
		error_message += 'Report Description cannot be longer than 200 characters.<br>';
	}
	if(selectedReportAccess == 'share' && $('#selected_group_names').val() == '' & $('#selected_user_ids' + reportId).val() == '') {
		error_message += 'Nothing has been selected to share.';
	}
	
	if(error_message == '') {
		$('#save_button').attr("disabled","disabled");
		$('#close_pop_up').attr("disabled","disabled");
		$('#adhoc_form').submit();
	}
	else {
		$('#error_message_div').html(error_message);
		$('#error_message_div').fadeIn('slow');
	}
}

//functions and variables for share view
var selected_group_names = '';
var selected_user_ids = '';

var selectedCategoryValue = '';
var selectedCategoryText= '';

function getGroupsToShareReport(){
	$.ajax({
		url : '/reports/get_groups_to_share_report/?which_report='+which_report+'&' +$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(), 
		success: function(data,statusText,xhr) {
			var data_arr = $.parseJSON(data);
			$("#group_select").empty();
			$.each(data_arr, function(key, value) {
				 $('#group_select').append($('<option>', { 
				        value: key,
				        text : value 
				}));
			});
			$('#group_select').on('change', function() {
				
				$(this).find('option:selected').each(
						function(){
							if($('#row_' + this.value).length <= 0 && this.value != 'multiselect-all') {
								insertRowInSelectedEntryTable(this.value, $(this).text());
							}
						}
		            );
				$(this).find('option:not(:selected)').each(
						 function(){
				            	deselectEntry(this.value, selectedCategoryValue);
				            	
						 });
				
				if($(this).val() != null) {
					$('#selected_group_names').attr('value',$(this).val().toString().replace('multiselect-all,', ''));
				}
				else {
					$('#selected_group_names').attr('value','');
				}
				
			});
			$('#group_select').multiselect({
				includeSelectAllOption: true,
				enableCaseInsensitiveFiltering: true,
	        	//enableFiltering: true,
	        	//filterBehavior: 'text',
	        	//filterPlaceholder: 'Search',
	        	maxHeight: 150
			});
		}
	});
}

function getUsersToShareReport(reportId, reportType, selected_items){
	$.ajax({
		url : '/reports/get_users_to_share_report/?which_report='+reportType+'&'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(), 
		success: function(data,statusText,xhr) {
			var data_arr = $.parseJSON(data);
			var full_user_list_size = 0;
			$("#user_select" + reportId).empty();
			$.each(data_arr, function(key, value) {
				full_user_list_size++;
				 $('#user_select' + reportId).append($('<option>', {
				        value: key,
				        text : value,
				}));
			});
			
			if(full_user_list_size > 0) {
				$('#report_access_share').removeAttr('disabled');
				$('#report_access_share_label').css('color', 'black');
				$('#report_access_share_label').html('Share');
			}
			else {
				var info = 'To add user in the share list:\n' + 
				'Go to Administration > Manage Accounts > Edit Access ' + 
				'(middle icon in the Actions column) to make the user you want to share this report with an API Admin';
				if(reportType == 'facility' || reportType == 'user_activity_summary') {
					info += ' or a Facility Leader';
				}
				
				var infoImage = '<img id="report_access_share_img" src="/images/information.png" title="' + info + '"/>';
				$('#report_access_share_label').html('No eligible user to share report ' + infoImage);
				
			}
			
			$('#user_select' + reportId).on('change', function() {
				$(this).find('option:selected').each(
		            function(){
		            	
		            	if($('#row_' + reportId + this.value).length <= 0 && this.value != 'multiselect-all') {
		            		insertRowInSelectedEntryTable(this.value, $(this).text(), reportId);
		            	}
		            });
				$(this).find('option:not(:selected)').each(
					 function(){
						 if($('#row_' + reportId + this.value).length > 0 && this.value != 'multiselect-all') {
			            	deselectEntry(this.value, selectedCategoryValue, reportId);
						 }
					 });
				if($(this).val() != null) {
					$('#selected_user_ids' + reportId).attr('value',$(this).val().toString().replace('multiselect-all,', ''));
				}
				else {
					$('#selected_user_ids' + reportId).attr('value','');
				}
			});
			$('#user_select' + reportId).multiselect({
				includeSelectAllOption: true,
	        	enableCaseInsensitiveFiltering: true,
	        	maxHeight: 150,
	        	numberDisplayed: 0
			});
			var selected_item_array = selected_items.split(',');
			
			if(full_user_list_size == selected_item_array.length && selected_items != null && selected_items != '') {
				$('#user_select' + reportId).multiselect('select', 'multiselect-all');
			}
			for(var i = 0; i < selected_item_array.length; i++) {
				if(selected_item_array[i] != null && selected_item_array[i] != '') {
					$('#user_select' + reportId).multiselect('select', selected_item_array[i]);
				}
			}
		}
	});
}
// ajax call to pull report names
function getReportNamesbyReportId(reportId,reportType)
{
	var export_image = '';

	$.ajax
	({
		url : '/reports/get_report_names_for_mutliple_downloads/?which_report_id='+reportId+'&reportType='+reportType+'&'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(),
		success: function(data,statusText,xhr)
		{

			var data_arr = $.parseJSON(data);
			$.each(data_arr, function(index,value){
				if (reportType == "adhoc_export_pdf"){
					export_image = '<img src="/images/icons/page_white_acrobat.png" class="link" style="border : 0;" alt="Export PDF" title="Export PDF">';
					$("#export_pdf_"+ index +"_from_panel").append(export_image+' ',value);
				}
				else {
					export_image = '<img src="/images/icons/page_white_excel.png" class="link" style="border : 0;" alt="Export Excel" title="Export Excel">';
					$("#multi_link_"+ index).append(export_image+' ',value);
				}


			});


		},
		error: (function(jqXHR, textStatus, errorThrown)
		{
			console.log(JSON.stringify(jqXHR));
			console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
		}),


	});
}


function changeElementSize(elementId) {
	$('#' + elementId).animate({height:'500px'}, 500);
}

function changeCategory() {
	selectedCategoryValue = $('#category_select').val();
	selectedCategoryText = $('#category_select option:selected').text();
	
	//add this line to point to user category, so the list always shows available users 
	//since we decided to hide groups for now
	selectedCategoryValue = 'user';
	if(selectedCategoryValue == 'group') {
		$('#group_select_div').show();
		$('#user_select_div').hide();
	}
	else {
		$('#user_select_div').show();
		$('#group_select_div').hide();
	}
}

function deselectEntry(entry, category, reportId) {
	$('#' + category + '_select' + reportId).multiselect('deselect', entry);
	$('#' + category + '_select' + reportId).multiselect('deselect', 'multiselect-all');
	var tr = $('#row_' + reportId + entry);
	var table = tr.parent();
	tr.css("background-color","#F5F5F5");
    tr.fadeOut(400, function(){
        tr.remove();
    });
	
	//figure out where to put focus now
	var row_count = table.children().length;
	if(row_count <= 2) {
		$('#share_select_users').focus();
	} else {
		if(tr.prev().children().children('a').length) { tr.prev().children().children('a').focus(); }
		else { tr.next().children().children('a').focus(); }
	}
	
    //assign adhoc form vlaues
    if($('#' + category + '_select' + reportId).val() != null) {
		$('#selected_' + category + '_names').attr('value',$('#' + category + '_select' +reportId).val().toString());
	}
	else {
		$('#selected_' + category + '_names').attr('value','');
	}
}

function insertRowInSelectedEntryTable(value, text, reportId, yourself) {
	var className = '';
	var action = '';
	if(!yourself) {
		className = 'fa fa-user';
		action = '<a href=# onclick="deselectEntry(\'' + value + '\',\'' + selectedCategoryValue + '\',\'' + reportId + '\');" title="Remove Item"><i style="color:#666666; font-size:15px" class="fa fa-trash-o"><span style="font-size: 0; line-height: 0; color: transparent;">Remove Item</span></i></a>';
	}
	else {
		className = 'fa fa-lock';
		action = '<i style="color:#666666; font-size:15px" class="fa fa-lock" title = "You"></i>';
	}
	$('#selected_entry_table' + reportId).append('<tr id="row_'+ reportId + value + '">' +
		'<td><i style="color:#666666; font-size:15px" class="' + className + '" title="User Name: ' + text +'"></i>&nbsp;&nbsp;' + text + '</td>' + 
		'<td align="center">' + action + '</td></tr>');
	
}

function toggleShareMenu(passedReportAccess) {
	if(passedReportAccess == 'shared') {
		//this lets our menu hang over the dialog edge
		$('.ui-dialog').css('overflow','visible'); 
		$('.ui-dialog-content').css('overflow','visible');
		
		$('#share_div').fadeIn('slow');
		$('#category_select').multiselect();
		$('#share_select_users').focus();
	}
	else {
		$('#share_div').fadeOut('slow');
	}
	
}
// end of share view functions

//drop down time period change
function update_time_period(report_id) {

	var new_time_period = document.getElementById('time_period_' + report_id);

	var new_time_period_excel = document.getElementById('new_time_period_excel_' + report_id);
	new_time_period_excel.value = new_time_period.value;
	
	var new_time_period_pdf = document.getElementById('new_time_period_pdf_' + report_id);
	new_time_period_pdf.value = new_time_period.value;
	
	var new_time_period_print = document.getElementById('new_time_period_print_' + report_id);
	new_time_period_print.value = new_time_period.value;
	
	var new_time_period_detail = document.getElementById('new_time_period_detail_' + report_id);
	new_time_period_detail.value = new_time_period.value;

}
//Remove users on deleted reports
function shared_remove_user(user_id,report_id, name) {
	   var message = 'Do you really want to remove this user access from this report?';
        if (confirm(message)) {
		 $.ajax({
				url : '/reports/get_share_user_to_delete/?report_id='+ report_id +'&user_id='+ user_id+'&'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(), 
				success: function(data) {
					var data_arr = $.parseJSON(data);
					var modifiedTime = '';
					$.each(data_arr, function(key, value) {
						modifiedTime = value;
					});
					$('#modified_time' + report_id).html(modifiedTime);
					//on success, hide  element user wants to delete.
					$('#row_'+ user_id).fadeOut(1000,function(){ 
						$('#row_'+user_id).remove();                    
					}); 
					$('#report_table').dataTable().fnDestroy();
					initializeAdhocReportDatatable();
				},
				error:function (xhr, ajaxOptions, thrownError){
					//On error, we alert user
					alert(thrownError);
				}
		});
	}
}

function save_objects_for_sharing_report(report_id) {
	
	var selected = $('#user_select' + report_id  + ' option:selected');
	var selected_items = '';
	for(var i = 0; i < selected.length; i++) {
		//alert(selected[i].value);
		if(selected[i].value.indexOf('all') < 0)  {
			selected_items += selected[i].value + ',';
		}
		
	}
	selected_items = selected_items.substring(0,selected_items.lastIndexOf(",")) + '';
	$.ajax({
		url : '/reports/save_objects_for_sharing_report/?report_id='+ report_id +'&selected_items='+ selected_items+'&'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(), 
		success: function(data) {
			var data_arr = $.parseJSON(data);
			var modifiedTime = '';
			$.each(data_arr, function(key, value) {
				modifiedTime = value;
			});
			$('#modified_time' + report_id).html(modifiedTime);
			
			$('#report_table').dataTable().fnDestroy();
			
			closeDialog('dialog' + report_id);
			initializeAdhocReportDatatable();
		},
		error:function (xhr, ajaxOptions, thrownError){
			//On error, we alert user
			alert(thrownError);
		}
});
}

function checkIfAnyCheckboxSelected() {
	var ifAnySelected = false;
	var checkboxes = jQuery(':input:checkbox');
	for(var i = 0; i < checkboxes.length; i++) {
		if(checkboxes[i].checked) {
			ifAnySelected = true;
			break;
		}
	}
	return ifAnySelected;
}

function enableAdhocReportFormMultipleButtons() {
	var report_id_delete_button = document.getElementById('report_id_delete_button');
	var export_pdf_button = document.getElementById('export_pdf_button');
	var export_excel_button = document.getElementById('export_excel_button');
	if(checkIfAnyCheckboxSelected()) {
		if(report_id_delete_button != null) {
			report_id_delete_button.disabled = false;
			report_id_delete_button.className = 'adhoc_button_submenu';
		}
		export_pdf_button.disabled = false;
		export_pdf_button.className = 'adhoc_button_submenu';
		export_excel_button.disabled = false;
		export_excel_button.className = 'adhoc_button_submenu';
	}
	else {
		if(report_id_delete_button != null) {
			report_id_delete_button.disabled = true;
			report_id_delete_button.className = 'adhoc_button_disabled';
		}
		export_pdf_button.disabled = true;
		export_pdf_button.className = 'adhoc_button_disabled';
		export_excel_button.disabled = true;
		export_excel_button.className = 'adhoc_button_disabled';
	}
	
}

function initializeAdhocReportDatatable() {
	$('#report_table').dataTable({
		//disable sorting on the 1st and 6th columns, which are columns of checkboxes, dropdowns, and action buttons respectively
		"aoColumnDefs": [{ 'bSortable': false, 'aTargets': [0,5,6]},
		                 { 'bSearchable': false, 'aTargets': [0,5,6]}],
		//set default sorting to Last Modified 2nd column, ascending
		"aaSorting": [[3,"desc"]],
		//"bPaginate": false,
		//set search box text
		"oLanguage": {
			"sSearch": "Find Report: ",
			"sInfo": "Showing _START_ to _END_ of _TOTAL_ Reports",
			"sLengthMenu":    "Showing _MENU_ Reports",
			"fnInfoCallback" : function(oS, iStart, iEnd, iMax, iTotal, sPre) {
				if(iTotal == 1) { return 'Showing ' + iStart + ' to ' + iEnd + ' of ' + iTotal + ' Report'; }
				return 'Showing ' + iStart + ' to ' + iEnd + ' of ' + iTotal + ' Reports';
			},
			"oPaginate" : { "sNext" : "Next »", "sPrevious" : "« Previous", },
			"sEmptyTable":    "No matching reports were found",
			"sZeroRecords":   "No matching reports were found",
		}
	});
	$('.dataTables_wrapper').css('font-size','12px');
}
